/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator.subscriber;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.KafkaSubscriber;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.KafkaSubscriberUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.AdminClient;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.TopicDescription;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TopicPatternSubscriber
implements KafkaSubscriber {
    private static final long serialVersionUID = -7471048577725467797L;
    private static final Logger LOG = LoggerFactory.getLogger(TopicPatternSubscriber.class);
    private final Pattern topicPattern;

    TopicPatternSubscriber(Pattern topicPattern) {
        this.topicPattern = topicPattern;
    }

    @Override
    public Set<TopicPartition> getSubscribedTopicPartitions(AdminClient adminClient) {
        LOG.debug("Fetching descriptions for all topics on Kafka cluster");
        Map<String, TopicDescription> allTopicMetadata = KafkaSubscriberUtils.getAllTopicMetadata(adminClient);
        HashSet<TopicPartition> subscribedTopicPartitions = new HashSet<TopicPartition>();
        allTopicMetadata.forEach((topicName, topicDescription) -> {
            if (this.topicPattern.matcher((CharSequence)topicName).matches()) {
                for (TopicPartitionInfo partition : topicDescription.partitions()) {
                    subscribedTopicPartitions.add(new TopicPartition(topicDescription.name(), partition.partition()));
                }
            }
        });
        return subscribedTopicPartitions;
    }
}

