<?php

namespace App\AuditResolvers;

use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Contracts\Resolver;
use Karmendra\LaravelAgentDetector\AgentDetector;
use Illuminate\Support\Facades\Request;

class DeviceTypeResolver implements Resolver
{
    public static function resolve(Auditable $auditable)
    {
        $agent_customer = $auditable->preloadedResolverData['user_agent'] ?? Request::header('User-Agent');
        $agent = new AgentDetector($agent_customer);

        return    $agent->device();
    }
}
