<?php

namespace App\Exports;

use App\Models\BalanceOverwrite;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class BalanceExport implements FromView
{
    public function view(): View
    {
        // نفس الكود من dataTable() لجمع البيانات
        $currencies = BalanceOverwrite::pluck('currency')->unique()->sort()->values()->toArray();

        $raw = BalanceOverwrite::selectRaw('
                ledgerUuid,
                currency,
                SUM(CASE WHEN balance > 0 THEN balance ELSE 0 END) as credit,
                SUM(CASE WHEN balance < 0 THEN ABS(balance) ELSE 0 END) as debit
            ')
            ->groupBy('ledgerUuid', 'currency')
            ->with('account.names')
            ->get();

        $grouped = [];
        $totals = [];

        foreach ($raw as $row) {
            $accountCode = $row->account->code ?? 'N/A';
            $accountName = $row->account->names->first()->name ?? 'N/A';
            $currency = $row->currency;
            $credit = $row->credit;
            $debit = $row->debit;

            $key = $accountCode;

            if (!isset($grouped[$key])) {
                $grouped[$key] = [
                    'account_code' => $accountCode,
                    'account_name' => $accountName,
                ];
            }

            $grouped[$key]["{$currency}_credit"] = $credit;
            $grouped[$key]["{$currency}_debit"] = $debit;

            $totals["{$currency}_credit"] = ($totals["{$currency}_credit"] ?? 0) + $credit;
            $totals["{$currency}_debit"] = ($totals["{$currency}_debit"] ?? 0) + $debit;
        }

        $totalsRow = [
            'account_code' => '',
            'account_name' => 'مجموع الصناديق',
        ];
        foreach ($currencies as $currency) {
            $totalsRow["{$currency}_credit"] = $totals["{$currency}_credit"] ?? 0;
            $totalsRow["{$currency}_debit"] = $totals["{$currency}_debit"] ?? 0;
        }

        $final = array_merge([$totalsRow], array_values($grouped));

        return view('exports.balance', [
            'data' => $final,
            'currencies' => $currencies,
        ]);
    }
}
