<?php

namespace App\Exports;

use App\Models\LedgerTransfer;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;

class LedgerTransferExport implements FromCollection, WithMapping, WithHeadings
{
    protected $from;
    protected $to;
    protected $type;
    protected $columns;
    protected $relations;

    public function __construct($from, $to, $type = null, array $columns = [], array $relations = [])
    {
        $this->from = $from;
        $this->to = $to;
        $this->type = $type;
        $this->columns = $columns;
        $this->relations = $relations;
    }

    public function collection()
    {
        $query = LedgerTransfer::query()->Transfer();

        if ($this->type === 'outgoing') {
            $query->whereNotNull('sender_id');
        } elseif ($this->type === 'incoming') {
            $query->whereNotNull('receiver_id');
        }

        if ($this->from && $this->to) {
            $query->whereBetween('created_at', [$this->from, $this->to]);
        }

        if (!empty($this->relations)) {
            $query->with($this->relations);
        }

        return $query->get();
    }

    public function map($t): array
    {
        return match ($this->type) {
            'outgoing' => [
                $t->reference,
                $t->sender?->name,

                $t->amount,
                $t->currency,
                $t->sender_client?->name,
                $t->sender_client?->getFullAddress(), //getFullAddress()
                $t->sender_client?->getPrimaryAddress()?->country ?? 'N/A',
                $t->sender_client?->IdentityType?->name ?? 'N/A',
                $t->sender_client?->identity_number ?? 'N/A',
                $t->recipient_client?->name ?? 'N/A',
                $t->recipient_client?->getFullAddress(), //getFullAddress()
                $t->receiver?->name,
                $t->reason?->name,


                $t->created_at->format('Y-m-d H:i:s'),
            ],
            'incoming' => [
                $t->reference,
                $t->receiver?->name,
                $t->recipientClient?->name,
                $t->delivery_amount,
                $t->delivery_currency,
                $t->created_at->format('Y-m-d H:i:s'),
            ],
            default => [],
        };
    }

    public function headings(): array
    {
        return $this->columns;
    }
}
