<?php

namespace App\Http\Controllers;

use App\Models\ApiConfig;
use App\Models\CustomLedgerAccount;
use Illuminate\Http\Request;

class AccountController extends Controller
{
    // App\Http\Controllers\CustomerController.php

    public function Search(Request $request)
    {


        $query = $request->input('search');
        $api_id = $request->api_id;
        if ($api_id) {

            $api_id = $request->api_id;
            $currency = $request->currency;
            $config = ApiConfig::find($api_id);

            $query = $request->input('search');
            $class = $config->apiType->class_name;



            $service = new $class();
            $configArray = json_decode($config->config_json, true);
            $configArray['base_url'] = $config->base_url;

            $service->setConfig($configArray);
            $service->authenticate();
            $clients = $service->getClientList($query, $currency);
            return response()->json(['results' => $clients]);
        }
        $results = CustomLedgerAccount::query()->with("names")
            ->when($query, fn($q) => $q->where('code', 'like', "%$query%"))
            ->limit(10)
            ->get()
            ->map(fn($result) => [
                'id' => $result->code,
                'text' => $result->code . "-" . $result->names->where("language", app()->getLocale())->first()->name ??  "N/A",
                "status" => "active"
            ]);

        return response()->json(['results' => $results]);
    }
}
