<?php

namespace App\Http\Controllers;

use App\DataTables\Agents\BalanceDataTable;
use App\DataTables\BalanceTableDataTable;
use App\Models\BalanceOverwrite;
use Illuminate\Http\Request;

class BalanceController extends Controller
{
    public function index(BalanceTableDataTable $dataTable)
    {
        $defaultCurrencies = BalanceOverwrite::pluck('currency')->unique()->sort()->values();

        $currencies = session('balance_selected_currencies', $defaultCurrencies->toArray());

        $filters['currencies'] = $currencies;

        return $dataTable->render('Balances.index', [
            'currencies' => $defaultCurrencies,
            'filters' => $filters,
        ]);
    }
    //////////////////////////////////Agent//////////////////////////
    public function Agent_index(BalanceDataTable $dataTable)
    {
        $defaultCurrencies = BalanceOverwrite::pluck('currency')->unique()->sort()->values();

        $currencies = session('agent_balance_selected_currencies', $defaultCurrencies->toArray());

        $filters['currencies'] = $currencies;

        return $dataTable->render('AgentPanel.Balances.index', [
            'currencies' => $defaultCurrencies,
            'filters' => $filters,
        ]);
    }
}
