<?php

namespace App\Http\Controllers;

use App\DataTables\ClientDataTable;
use App\Models\Client;
use Illuminate\Http\Request;

class ClientController extends Controller
{
    public function index(ClientDataTable $dataTable)
    {

        return $dataTable->render('Clients.index');
    }
    public function Search(Request $request)
    {


        $query = $request->input('search');

        $results = Client::query()
            ->when($query, fn($q) => $q->where('identity_number', 'like', "%$query%"))
            ->limit(10)
            ->get()
            ->map(fn($result) => [
                'id' => $result->id,
                'text' => $result->identity_number . "-" . $result->name,
                "status" => "active"
            ]);

        return response()->json(['results' => $results]);
    }
}
