<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class PartnerApiController extends Controller
{
    public function index()
    {
        return view("api.Partners");
    }
    public function Search(Request $request)
    {

        $api_id=$request->api_id;

        $api=ApiConfig::find($api_id);

        $query = $request->input('search');

        $results = LedgerTransfer::query()
            ->when($query, fn($q) => $q->where('reference', 'like', "%$query%"))
            ->limit(10)
            ->get()
            ->map(fn($result) => [
                'id' => $result->id,
                'text' => $result->reference,
                "status" => "active"
            ]);

        return response()->json(['results' => $results]);
    }
}
