<?php

namespace App\Http\Controllers;

use App\DataTables\ReportExportedLogDataTable;
use App\DataTables\ReportExportLogDataTable;
use Illuminate\Http\Request;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Support\Facades\Log;


class ReportController extends Controller
{
    protected $ledgerApiUrl = '/api/ledger/report';
    public function  getData()
    {

        try {
            $client = new Client();
            $response = $client->post(url('/api/ledger/report'), [
                'headers' => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json',
                ],
                'json' => [
                    'name' => 'trialBalance',
                    'currency' => request('currency', 'USD'),
                    'fromDate' => request('fromDate', now()->subMonth()->format('Y-m-d')),
                    'toDate' => request('toDate', now()->format('Y-m-d')),
                    'options' => [
                        'depth' => request('depth', 3),
                        'language' => [request('language', 'en')]
                    ]
                ]
            ]);

            $data = json_decode($response->getBody(), true);
            Log::info('Trial Balance Report Response', $data['report']['accounts']);
            return collect($data['report']['accounts'] ?? []);
        } catch (RequestException $e) {
            Log::error('Ledger API Error: ' . $e->getMessage());
            return collect(); // Return empty collection on error
        }
    }
    public  function index(ReportExportedLogDataTable $dataTable)
    {
        return $dataTable->render('Reports.index');
    }
}
