<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class EnsureAgentEmailIsVerified
{
    public function handle($request, Closure $next)
    {
        $user = Auth::guard('agent')->user();

        if (! $user) {
            return redirect()->route('agent.login');
        }

        if (! $user->hasVerifiedEmail()) {
            return redirect()->route('agent.verification.notice');
        }

        return $next($request);
    }
}
