<?php

namespace App\Http\Middleware;

use App\Models\Agent;
use Closure;
use Illuminate\Http\Request;

use NunoMazer\Samehouse\Facades\Landlord;


use App\Models\Company;
use Session;

class Tenancy
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {

        if (auth()->check()) {
            $session = Session::get('tenant_impersonation');

            $tenant = $session ?? auth()->user()->agent_id;
            $admin = auth()->user();
            if (isset($session)) {

                $agent = Agent::withoutGlobalScope('agent_id')->with('child')->find($tenant);
            } else {
                if ($tenant == 1 && auth()->user()->id != 1) {

                    $kids = Agent::withoutGlobalScope('agent_id') - pluck('id')->toArray();
                } else {
                    $company = Agent::withoutGlobalScope('agent_id')->with('child')->find($tenant);
                    $kids = $company->getallchildid();
                }
            }


            Landlord::addTenant('agent_id', $kids);
            if ($tenant != 1) {


                Landlord::applyTenantScopesToDeferredModels();
            } else {
                Landlord::removeTenant('company_id');
            }
        }
        return $next($request);
    }
}
