<?php

namespace App\Livewire\Accounts;

use App\Models\Account;
use Livewire\Component;

class Listaccounts extends Component
{
    public  $accounts;
    public $search;
    protected function  getListeners()
    {
        return [
            "UpdateAccountsList" => "loadAllAccounts"
        ];
    }
    public function updatedSearch($value)
    {
        if (empty($value)) {
            $this->reset('search');
            $this->loadAllAccounts(); // Custom method to load all accounts
        }
    }
    public function loadAllAccounts()
    {
        $this->accounts = Account::get();
    }
    public  function mount()
    {
        $this->accounts = Account::get();
    }

    public function Search()
    {
        $this->accounts = Account::where('name', 'like', '%' . $this->search . '%')->get();
    }
    public  function Delete($id)
    {
        $account = Account::with("wallet")->find($id);
        $balance = $account->balance;
        if ($balance > 0) {
            $this->dispatch("sweetalert:error", ['msg' => "Account Has Money, Can't Delete", "title" => "Warning", "type" => "warning"]);
            return;
        }
        $account->delete();
        $this->dispatch("sweetalert:success", ['msg' => "Account Deleted Successfully", "title" => "Success", "type" => "success"]);
        $this->loadAllAccounts();
    }
    public function showWalletTransactions($wallet_id)
    {


        $this->dispatch('showWalletTransactions', $wallet_id);
    }
    public function render()
    {
        return view('livewire.accounts.listaccounts');
    }
}
