<?php

namespace App\Livewire\AgentPanel\Dashboard;

use App\Models\LedgerApproval;
use App\Models\LedgerExchange;
use App\Models\News;
use Carbon\Carbon;
use Livewire\Component;
use Rawilk\Settings\Facades\Settings;

class Statistics extends Component
{
  public $statistics = [];
  public $balances;
  public $agent;
  public $news = [];
  public  $based_balance = 0;
  protected function  getListeners()
  {
    return [
      'RefreshDashboardStatistics' => 'RefreshDashboardStatistics'
    ];
  }
  public  function  RefreshDashboardStatistics()
  {
    $this->LoadStatistics();
    $this->balances = $this->getBalances();
    $this->based_balance = getBaseCurrencyBalance($this->balances);
  }
  public function mount($agent = null)
  {
    $this->news = News::where('is_active', 1)->get();

    if ($agent) {
      $this->agent = $agent;
    } else
      $this->agent = auth()->guard('agent')->user()->agent->rootAgent();
    $this->LoadStatistics();
    $this->balances = $this->getBalances();
    if (Settings::get('agent.show_based_balance', 1)) {
      $this->based_balance = getBaseCurrencyBalance($this->balances);
    }
  }

  public function  LoadStatistics()
  {
    $today = Carbon::today();
    $last_three_months = Carbon::now()->subMonths(3);
    $rootAgent = $this->agent->rootAgent();
    $this->statistics = [

      'received_transfers' => $rootAgent->getallReceivedTransfers()->where('status', 'pending')->whereDate('created_at', '>=', $last_three_months)->count(),
      'sent_transfers' => $rootAgent->sentTransfers()->whereDate("created_at", $today)->whereNotIn('status', ['cancelled', 'deleted'])->count(),
      'delivered_transfers' => $rootAgent->getallReceivedTransfers()->where('status', 'completed')->whereDate("created_at", $today)->count(),
      'exchange_transfer' => LedgerExchange::where("sender_id", $rootAgent->id)->whereDate("created_at", $today)->count(),
      "sent_approved_transfer" => LedgerApproval::where("sender_id", $rootAgent->id)->whereDate("created_at", $today)->count(),
      "received_approved_transfer" => LedgerApproval::where("receiver_id", $rootAgent->id)->whereDate("created_at", $today)->count(),
      "not_paid_transfers" => $rootAgent->getallReceivedTransfers()->where('status', 'completed')->where("is_paid", 0)->whereDate('created_at', '>=', $last_three_months)->count(),
      "not_collected_transfers" => $rootAgent->sentTransfers()->where('status', 'pending')->where("is_collected", 0)->whereDate('created_at', '>=', $last_three_months)->count(),

    ];
  }

  public function getBalances()
  {
    if (!$this->agent) {
      return [];
    }

    return $this->agent->getAgentBalances();
  }
  public function render()
  {
    return view('livewire.agent-panel.dashboard.statistics');
  }
}
