<?php

namespace App\Livewire\Agents;

use App\Models\Agent;
use Livewire\Component;
use PeterColes\Countries\CountriesFacade;

class AddBranch extends Component
{
  public $branch = [

    'name' => '',

    'parent_id' => null,
  ];
  public $agents = [],
    $countries = [];
  public $address = [
    'country' => 'SY',
    'state' => null,
    'city' => null,
    'neighborhood' => null,
    'district' => null,


  ];
  public $action_type = "add";
  protected function getListeners()
  {
    return [
      'editBranch' => 'editBranch',
      'openAddBranchModal' => 'openAddBranchModal',
      'deleteBranchAlert' => 'deleteAlert',
      'deleteBranch' => 'deleteBranch',
    ];
  }
  public function openAddBranchModal($action = "add")
  {
    $this->action_type = $action;
    $this->branch = [
      'name' => '',
      'parent_id' => null,
    ];
    $this->address = [
      'country' => 'SY',
      'state' => null,
      'city' => null,
      'neighborhood' => null,
      'district' => null,
      'full_address' => '',
    ];
    $this->dispatch("open_modal", ['action' => "show", "id" => "AddNewBranchModal"]);
  }
  public function editBranch($id)
  {
    $branch = Agent::with('address')->find($id);
    if (!$branch) {
      $this->reset(['branch', 'address']);
      return;
    }
    $this->branch = $branch->toArray();
    $this->address = $branch->address->toArray();
    $this->action_type = "edit";
    $this->dispatch("open_modal", ['action' => "show", "id" => "AddNewBranchModal"]);
  }
  public function deleteAlert($id)
  {
    $this->dispatch('areyousure', ['msg' => __("alerts.areyousure"), 'emitName' => 'deleteBranch', 'action' => __("actions.delete"), 'title' => __("alerts.delete"), 'data' => ['id' => $id]]);
  }
  public function deleteBranch($data)
  {
    $id = $data['id'];
    $branch = Agent::find($id);
    if (!$branch) {
      $this->dispatch('sweetalert:error', ['msg' => __("alerts.branch_not_found"), "title" => __("alerts.error"), "type" => "error"]);
      return;
    }
    $branch->delete();
    $this->dispatch("RefreshYajraDatatable", ['table' => 'branch-table']);
    $this->dispatch('sweetalert:success', ['msg' => __("alerts.deleted_successfully"), "title" => __("Success"), "type" => "success"]);
    $this->dispatch("UnBlockUI");
  }
  public function mount()
  {

    $this->agents = Agent::whereNull('parent_id')->where('is_active', 1)->get();
    $this->countries = CountriesFacade::lookup(app()->getLocale())->all();
  }

  public function Save()
  {
    $this->validate([
      'branch.name' => 'required|string|max:255',
      'branch.parent_id' => 'required|exists:agents,id',
      'branch.phone' => 'required|string|max:20',
      'address.country' => 'required|string|max:255',
      'address.state' => 'nullable|string|max:255',
      'address.city' => 'required|string|max:255',
      'address.neighborhood' => 'nullable|string|max:255',
      'address.district' => 'nullable|string|max:255',
      'address.full_address' => 'required|string|max:255',
    ]);
    if (!isset($this->branch['id'])) {
      $this->branch['code'] = $this->generateBranchCode();
      $branch = Agent::create($this->branch);
    } else {
      $branch = Agent::find($this->branch['id']);

      $branch->update($this->branch);
    }
    $branch->createOrUpdateAddress($this->address);
    $this->dispatch("RefreshYajraDatatable", ['table' => 'branch-table']);
    $this->dispatch("open_modal", ['action' => "hide", "id" => "AddNewBranchModal"]);
    $this->dispatch('sweetalert:success', ['msg' => __("alerts.saved_successfully"), "title" => __("Success"), "type" => "success"]);
    $this->reset(['branch', 'address']);
  }

  public  function generateBranchCode()
  {
    $prefix = "BRANCH_";
    $code = mt_rand(100000, 999999);
    $branch = Agent::where('code', $code)->first();
    if ($branch) {
      return $this->generateBranchCode();
    }
    return $prefix . $code;
  }
  public function render()
  {
    return view('livewire.agents.add-branch');
  }
}
