<?php

namespace App\Livewire\AuditLogs;

use Livewire\Component;
use App\Models\User;
use App\Models\Agent;

class Index extends Component
{
  public $selectedDate = '';
  public $selectedUser = '';
  public $selectedEvent = '';
  public $selectedModel = '';
  public $searchQuery = '';

  public function updatedSelectedDate()
  {
    $this->dispatch('filtersApplied', [
      "filters" => $this->getSelectedFilters(),
      "table_id" => 'audit-table'
    ]);
  }

  public function updatedSelectedUser()
  {
    $this->dispatch('filtersApplied', [
      "filters" => $this->getSelectedFilters(),
      "table_id" => 'audit-table'
    ]);
  }

  public function updatedSelectedEvent()
  {
    $this->dispatch('filtersApplied', [
      "filters" => $this->getSelectedFilters(),
      "table_id" => 'audit-table'
    ]);
  }

  public function updatedSelectedModel()
  {
    $this->dispatch('filtersApplied', [
      "filters" => $this->getSelectedFilters(),
      "table_id" => 'audit-table'
    ]);
  }

  public function updatedSearchQuery()
  {

    $this->dispatch('filtersApplied', [
      "filters" => $this->getSelectedFilters(),
      "table_id" => 'audit-table'
    ]);
  }
  public function applyFilters()
  {
    $this->dispatch('filtersApplied', [
      "filters" => $this->getSelectedFilters(),
      "table_id" => 'audit-table'
    ]);
  }
  public function clearFilters()
  {
    $this->selectedDate = now()->format('Y-m-d');
    $this->selectedUser = '';
    $this->selectedEvent = '';
    $this->selectedModel = '';
    $this->searchQuery = '';

    $this->dispatch('filtersApplied', [
      "filters" => $this->getSelectedFilters(),
      "table_id" => 'audit-table'
    ]);
  }

  // Helper method to get all selected filters as an array
  public function getSelectedFilters()
  {
    $filters = [
      'created_at' => $this->selectedDate,
      'user_id' => $this->selectedUser,
      'event' => $this->selectedEvent,
      'auditable_type' => $this->selectedModel,
      'search' => $this->searchQuery,
    ];

    return $filters;
  }

  public function getUsersProperty()
  {
    $users = collect();

    // Get web users
    $webUsers = User::select('id', 'name', 'email')
      ->get()
      ->map(function ($user) {
        return [
          'id' =>   $user->id,
          'name' => $user->name . ' (Web)',
          'email' => $user->email,
          'guard' => 'web'
        ];
      });

    // Get agent users


    return $webUsers;
  }

  public function getEventsProperty()
  {
    return [
      'created' => __('audit.events.created'),
      'updated' => __('audit.events.updated'),
      'deleted' => __('audit.events.deleted'),
      'restored' => __('audit.events.restored'),
    ];
  }

  public function getModelsProperty()
  {
    return [
      'App\Models\LedgerTransfer' => __('audit.models.ledger_transfer'),
      'App\Models\LedgerBooking' => __('audit.models.ledger_booking'),
      'App\Models\Client' => __('audit.models.client'),
      'App\Models\User' => __('audit.models.user'),
      'App\Models\Agent' => __('audit.models.agent'),
      'App\Models\LedgerExchange' => __('audit.models.ledger_exchange'),
      'App\Models\LedgerApproval' => __('audit.models.ledger_approval'),
    ];
  }

  public function render()
  {
    return view('livewire.audit-logs.index', [
      'users' => $this->users,
      'events' => $this->events,
      'models' => $this->models,
    ]);
  }
}
