<?php

namespace App\Livewire\Client;

use App\Events\RefreshDataTable;
use App\Models\Agent;
use App\Models\Client;
use App\Models\IdentityType;
use Livewire\Component;
use PeterColes\Countries\CountriesFacade;
use Livewire\WithFileUploads;
use Livewire\Attributes\Validate;
use OwenIt\Auditing\Events\AuditCustom;
use Illuminate\Support\Facades\Event;

class Add extends Component
{
    public $show = true;
    public $client = ['type' => 1, 'identity_type' => 1, 'gender' => "male", 'nationality' => "سوريا", 'id' => null, 'date_of_birth' => null];
    public  $address = ['country' => "سوريا"];
    public $identity_types = [];
    public $attachments = [];
    public  $countries = [];

    use WithFileUploads;
    #[Validate('mimes:jpeg,png,jpg,pdf|max:1024')] // 1MB Max
    protected function getListeners()
    {
        return [
            'LoadClientData' => 'LoadClientData',
            'HideClientCard' => 'HideClientCard',
            'editClient' => 'EditClient',
            'deleteClient' => 'DeleteClient',
            'deleteAlert' => 'deleteAlert',
            'updateClient' => 'CreateClient',
            'AddNewClientEvent' => 'AddNewClientEvent',

        ];
    }

    public function AddNewClientEvent()
    {
        $this->client = ['type' => 1, 'identity_type' => 1, 'gender' => "male", 'nationality' => "سوريا", 'id' => null];
        $this->address = [];
        $this->attachments = [];
    }
    public function deleteAlert($id)
    {
        $this->dispatch('areyousure', ['msg' => __("alerts.areyousure"), 'emitName' => 'deleteClient', 'action' => __("actions.delete"), 'title' => __("alerts.delete"), 'data' => ['client_id' => $id]]);
    }
    public  function  DeleteClient($data)
    {
        try {
            $client_id = $data['client_id'];
            $client = Client::find($client_id);

            $client->delete();
            $this->dispatch("RefreshYajraDatatable", ['table' => 'client-table']);
            event(new RefreshDataTable("client-table"));
            $this->dispatch('sweetalert:success', ['msg' => __("alerts.deleted_successfully"), "title" => __("alerts.success"), "type" => "success"]);
        } catch (\Exception $e) {
            $this->dispatch("sweetalert:error", ['msg' => __('alerts.something_went_wrong'), "title" => "Error", "type" => "error"]);
        }
        $this->dispatch("UnBlockUI");
    }
    public function EditClient($client_id)
    {
        $client = Client::find($client_id);
        $this->client = $client->toArray();

        $this->address = $client->getPrimaryAddress()->toArray();
        $this->dispatch('open_modal', [
            'action' => 'show',
            'id' => 'AddClientModal',
        ]);
    }
    public function HideClientCard($show)
    {

        $this->show = $show['show'];
    }
    public  function LoadClientData($id)
    {
        $client = Client::find($id['id']);

        $this->client = $client->toArray();
        $this->address = $client->getPrimaryAddress()->toArray();
        //  $this->dispatch('editForm');
    }
    public function  UploadAttatchments($client_id)
    {
        $transfer = Client::find($client_id);

        if (count($this->attachments) > 0) {
            $transfer->clearMediaCollection('attatchments');
            foreach ($this->attachments as $attachment) {

                $transfer
                    ->addMedia($attachment->getRealPath())
                    ->usingFileName($attachment->getClientOriginalName())
                    ->toMediaCollection('attachments');
            }
        }
    }
    public  function mount()
    {
        $this->identity_types = IdentityType::get();
        $this->countries = CountriesFacade::lookup(app()->getLocale())->all();
    }
    public function ConfirmUpdate()
    {
        $this->dispatch('areyousure', ['msg' => __("alerts.areyousure"), 'emitName' => 'updateClient', 'action' => __("alerts.update_client"), 'title' => __("alerts.update"), 'data' => []]);
    }
    public  function CreateClient()
    {
        $this->validate([
            'client.name.ar' => 'required',
            'client.name.en' => 'nullable',
            'client.gender' => 'required',

            'client.nationality' => 'required',
            'client.identity_type' => 'required',
            'client.identity_number' => 'required|unique:clients,identity_number,' . ($this->client['id'] ?? NULL),
            'client.place_of_birth' => 'required',


            'client.phone' => 'required|numeric'
        ]);

        Client::disableAuditing();
        if (isset($this->client['id'])) {
            $client = Client::find($this->client['id']);

            $newData = $this->client;
            $oldData = $client->toArray();
            $dirty = [];

            foreach ($newData as $key => $newValue) {
                // Handle translatable fields like 'name'
                if (in_array($key, $client->translatable ?? []) && is_array($newValue)) {
                    foreach ($newValue as $locale => $val) {
                        $oldVal = $client->getTranslation($key, $locale);
                        if ((string)$oldVal !== (string)$val) {
                            $dirty["{$key}.{$locale}"] = [
                                'old' => $oldVal,
                                'new' => $val,
                            ];
                        }
                    }
                } else {
                    // Regular fields
                    $oldVal = $oldData[$key] ?? null;
                    if ((string)$oldVal !== (string)$newValue) {
                        $dirty[$key] = [
                            'old' => $oldVal,
                            'new' => $newValue,
                        ];
                    }
                }
            }

            if (!empty($dirty)) {
                $client->update($newData);

                $client->enableAuditing();
                $client->auditEvent = 'Update_Client';
                $client->isCustomEvent = true;

                $client->auditCustomOld = collect($dirty)->map(fn($v) => $v['old'])->toArray();
                $client->auditCustomNew = collect($dirty)->map(fn($v) => $v['new'])->toArray();

                Event::dispatch(new AuditCustom($client));
                $client->disableAuditing();
                event(new RefreshDataTable("client-table"));
            }
        } else {
            $client = Client::create($this->client);

            $client->createOrUpdateAddress($this->address);
            $client->enableAuditing();
            $client->auditEvent = 'Create_Client';
            $client->isCustomEvent = true;

            // Flatten all array fields (e.g., translatable fields like name)
            $clientArray = $client->toArray();
            $flatData = [];

            foreach ($clientArray as $key => $value) {
                if (is_array($value)) {
                    foreach ($value as $subKey => $subVal) {
                        $flatData["{$key}.{$subKey}"] = $subVal;
                    }
                } else {
                    $flatData[$key] = $value;
                }
            }

            $client->auditCustomOld = [];
            $client->auditCustomNew = $flatData;

            Event::dispatch(new AuditCustom($client));

            $client->disableAuditing();
        }
        $this->dispatch('saveMedia', \App\Models\Client::class, $client->id);
        $this->dispatch("toastr:success", ['msg' => __("alerts.added_successfully"), "title" => __("alerts.Success"), "type" => "success"]);
        $this->dispatch("RefreshYajraDatatable", ['table' => 'client-table']);
        $this->dispatch("getClientData", ['id' => $client->id]);
        // $this->dispatch("LoadClientData", ['id' => $client->id]);
        if (!isset($this->client['id']))
            $this->client = [];
        event(new RefreshDataTable("client-table"));
    }
    public function render()
    {
        return view('livewire.client.add');
    }
}
