<?php

namespace App\Livewire\Components;

use Illuminate\Support\Facades\Log;
use Livewire\Component;
use Livewire\WithFileUploads;
use Illuminate\Support\Str;

class AttachmentsRepeater extends Component
{
  use WithFileUploads;

  public $attachments = [];
  public $collection = 'default';
  public $id; // Add this to store component instance ID
  public $componentId;
  protected $listeners = ['saveMedia' => 'saveMediaToModel'];

  public function mount($collection = 'default')
  {
    $this->collection = $collection;
    $this->attachments = [['file' => null, 'type' => null, 'mode' => 'upload']];
    $this->id = Str::random(10); // Generate unique ID for each component instance
    $this->componentId = 'attachments-repeater-' . Str::random(8); // More readable ID

  }

  public function addAttachment()
  {
    $this->attachments[] = ['file' => null, 'type' => null, 'mode' => 'upload'];
  }

  public function removeAttachment($index)
  {
    // Clean up camera stream if exists
    if (
      isset($this->attachments[$index]['mode']) &&
      $this->attachments[$index]['mode'] === 'camera' &&
      $this->attachments[$index]['file']
    ) {
      @unlink($this->attachments[$index]['file']->getRealPath());
    }

    unset($this->attachments[$index]);
    $this->attachments = array_values($this->attachments);
  }
  public function updatedAttachments($value, $key)
  {
    Log::info($key);
    Log::info($value);
    // Handle when a camera photo is set (base64 string)
    if (Str::startsWith($value, 'data:image')) {
      $index = explode('.', $key)[1];
      $this->attachments[$index]['file'] = $value;
    }
  }
  public function setCameraPhoto($index, $base64Image)
  {
    $this->attachments[$index]['file'] = $base64Image;
    $this->attachments[$index]['mode'] = 'camera'; // Ensure mode is set

    // Debugging
    Log::info("Camera photo set for index: {$index}");
    Log::info("Image data: " . substr($base64Image, 0, 50) . "...");
  }
  public function updateMode($index)
  {
    // No need for additional logic here since Alpine handles it
  }

  public function saveMediaToModel($modelType, $modelId)
  {
    // $this->validate([
    //     'attachments.*.file' => 'required',
    //     'attachments.*.type' => 'required|string',
    // ]);

    $model = $modelType::findOrFail($modelId);
    Log::info($model);
    Log::info("yesss");
    Log::info($this->attachments);
    foreach ($this->attachments as $attachment) {
      if (!$attachment['file']) continue;

      if (Str::startsWith($attachment['file'], 'data:image')) {
        // Handle base64 image
        Log::info('base64 image');
        $image = explode(',', $attachment['file'])[1];
        $decoded = base64_decode($image);
        $tempPath = storage_path('app/livewire-tmp/' . Str::uuid() . '.png');
        file_put_contents($tempPath, $decoded);
        $file = new \Illuminate\Http\File($tempPath);
        Log::info($file);
      } else {
        // Handle regular file upload
        $file = $attachment['file'];
      }

      $model->addMedia($file->getRealPath())
        ->usingName('attachment')
        ->withCustomProperties(['type' => $attachment['type']])
        ->toMediaCollection($this->collection);
    }

    $this->reset('attachments');
    $this->attachments = [['file' => null, 'type' => null, 'mode' => 'upload']];
  }

  public function render()
  {
    return view('livewire.components.attachments-repeater');
  }
}
