<?php

namespace App\Livewire\Components;

use App\Models\Facade;
use Livewire\Component;

class Facades extends Component
{
    public $facades = [], $selected_facades = [], $select_all = false;
    public $facade_name;
    public $model;
    public function UpdatedSelectAll($value)
    {
        if ($value) {
            $this->selected_facades = array_column($this->facades, 'id');
        } else {
            $this->selected_facades = [];
        }
    }
    public function AddFacade()
    {
        $rules = [
            'facade_name' => 'required',
        ];
        $this->validate($rules);
        $name = $this->facade_name;
        $facade = Facade::create([
            'name' => $name,
        ]);
        $this->facades[] = $facade;
        $this->selected_facades[] = $facade['id'];
        $this->facade_name = null;
    }
    public function SaveFacades()
    {
        $this->validate([
            'selected_facades' => 'required',
        ]);
        $this->model->facades()->sync($this->selected_facades);
        $this->dispatch("sweetalert:success", ['msg' => 'Facades updated successfully', 'title' => 'Success']);
    }
    public function render()
    {
        return view('livewire.components.facades');
    }
}
