<?php

namespace App\Livewire\Components;

use Illuminate\Support\Facades\Log;
use Livewire\Component;

class FilterComponent extends Component
{
  public $model; // The model class, e.g., App\Models\Invoice
  public $table_id;
  public $filters = [
    // 'status' => ['type' => 'x-Mulk.select2', 'options' => ['paid', 'unpaid', 'pending']],
    // 'due_date' => ['type' => 'date'],
    // 'contract' => ['type' => 'x-Mulk.select2', 'options' => [1, 2, 3]],
    // 'tenant' => ['type' => 'x-Mulk.select2', 'options' => [1, 2, 3]],
    // 'property' => ['type' => 'x-Mulk.select2', 'options' => [1, 2, 3]],
  ];
  public $selectedFilters = [];
  public function mount($model, $table_id, $filters = [])
  {

    $this->model = $model;
    $this->selectedFilters =  $filters;

    $this->table_id = $table_id;
    $this->applyFilters();
    $this->dispatch('filtersApplied', ["filters" => $this->selectedFilters, "table_id" => $this->table_id]);
    $this->initFilters();
  }

  public function initFilters()
  {
    $filterMethod = 'getFilterableFields';

    if (method_exists($this->model, $filterMethod)) {

      $this->filters = $this->model::$filterMethod();
    }
    foreach ($this->filters as $field => $config) {
      $this->selectedFilters[$config['key']] = null;
    }
  }

  public function applyFilters()
  {

    Log::info($this->selectedFilters);
    $this->dispatch('filtersApplied', ["filters" => $this->selectedFilters, "table_id" => $this->table_id]);
  }
  public  function resetFilters()
  {
    $this->selectedFilters = [];
    $this->dispatch('filtersApplied', ["filters" => $this->selectedFilters, "table_id" => $this->table_id]);
  }
  public function render()
  {
    $filters = $this->filters;

    return view('livewire.components.filter-component', compact('filters'));
  }
}
