<?php

namespace App\Livewire\Components;

use Livewire\Component;
use Livewire\Attributes\Modelable;

class Repeater extends Component
{
    #[Modelable]
    public array $items = [];
    public array $fields = []; // e.g. ['label', 'quantity', 'unit']
    public string $prefix = 'item'; // optional to namespace multiple repeaters
    public string $locale = 'tr'; // default
    public bool $singleColumn = true;
    protected function getListeners()
    {
        return [
            'getDataFromRepeaters' => 'getData',
            'resetRepeaters' => 'resetRepeater'
        ];
    }
    public function resetRepeater()
    {
        $this->items = [
            collect($this->fields)
                ->pluck('name')
                ->mapWithKeys(fn($name) => [$name => ''])
                ->toArray()
        ];
    }
    public function mount($fields = [], $initial = [], $prefix = 'item', $locale = null)
    {
        $this->fields = $fields;
        $this->prefix = $prefix;
        $this->locale = $locale ?? app()->getLocale();

        $this->items = !empty($initial) ? $initial : [
            collect($fields)->pluck('name')->mapWithKeys(fn($k) => [$k => ''])->toArray()
        ];
    }

    public function addItem()
    {
        $newItem = collect($this->fields)
            ->pluck('name')
            ->mapWithKeys(fn($name) => [$name => ''])
            ->toArray();

        $this->items[] = $newItem;
    }

    public function removeItem($index)
    {
        unset($this->items[$index]);
        $this->items = array_values($this->items); // reindex
    }
    public function getData($prefix = null)
    {
        if ($this->prefix === $prefix) {
            $this->dispatch('repeaterUpdated', $this->prefix, $this->items);
        }
    }


    public function render()
    {
        return view('livewire.components.repeater');
    }
}
