<?php

namespace App\Livewire\Components;

use Bavix\Wallet\Internal\Service\MathServiceInterface;
use Bavix\Wallet\Models\Transaction;
use Bavix\Wallet\Models\Wallet;
use Livewire\Component;

class WalletTransactions extends Component
{
    public $walletId;
    public $transactions = [];
    public $showModal = false;

    protected $listeners = ['showWalletTransactions' => 'loadTransactions'];

    public function loadTransactions($walletId)
    {
        if ($walletId == 0) {
            $this->dispatch("sweetalert:error", ['type' => 'error', 'msg' => __('alerts.no_transaction_exists')]);
            return;
        }
        try {
            $this->walletId = $walletId;

            $math = app(MathServiceInterface::class);


            $this->transactions = Transaction::query()->where('wallet_id', $walletId)
                ->latest()

                ->get()

                ->map(function ($transaction) use ($math) {
                    $type = $transaction->type;
                    $type == "deposit" ? $newBalance = $math->add($transaction->meta['to_old_balance'] ?? 0, $transaction->amount, true) : $newBalance = $math->sub($transaction->meta['from_old_balance'] ?? 0, $transaction->amount, true);
                    return [
                        'id' => $transaction->id,
                        'type' => $transaction->type,
                        'amount' => $transaction->amount,
                        'old_balance' =>  $transaction->meta['from_old_balance'] ?? 0,
                        'new_balance' => $newBalance,
                        'meta' => $transaction->meta,
                        'created_at' => $transaction->created_at->format('d-m-Y H:i:s'),
                    ];
                });

            $this->dispatch('refreshDatatable');
            $this->dispatch("open_modal", ['action' => "show", "id" => "WalletTransactionModal"]);

            $this->showModal = true;
        } catch (\Exception $e) {
            $this->dispatch('sweetalert:error', ['type' => 'error', 'msg' => __('alerts.some_things_went_wrong')]);
        }
    }
    public function render()
    {
        return view('livewire.components.wallet-transactions');
    }
}
