<?php

namespace App\Livewire\Currency;

use App\Models\Currency;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;
use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\Attributes\Validate;

class Add extends Component
{
  use WithFileUploads;
  public $currencies = ['is_default' => false];
  public $custom_code;
  public  $currency = ['code' => null, 'name' => [], 'color' => "#000000", 'is_default' => false];
  public  $currency_object;
  public  $avatar;
  public $editing = false;
  public $confirmedDefaultChange = false;
  #[Validate('mimes:jpeg,png,jpg,pdf|max:1024')] // 1MB Max

  protected $rules = [
    'currency.code' => 'required|unique:currencies,code',
    'currency.name' => 'required',
    'currency.exchange_rate' => 'required|numeric',


  ];
  protected function getListeners()
  {
    return [
      'editCurrency' => 'editCurrency',
      'deleteCurrency' => 'deleteCurrency',
      'openAddCurrencyModal' => 'openAddCurrencyModal',
      'DeleteAlert' => 'DeleteAlert',
      'changeDefaultCurrency' => 'changeDefaultCurrency'
    ];
  }
  public function DeleteAlert($currency_id)
  {
    $this->dispatch('areyousure', ['msg' => __("alerts.areyousure"), 'emitName' => 'deleteCurrency', 'action' => __("actions.delete_currency"), 'title' => __("actions.delete_currency"), 'data' => ['currency_id' => $currency_id]]);
  }
  public  function openAddCurrencyModal()
  {
    $this->editing = false;
    $this->currency = ['code' => null, 'name' => [], 'color' => "#000000", 'is_default' => false];
    $this->confirmedDefaultChange = false;
    $this->dispatch("open_modal", ['action' => "show", "id" => "MoneyCurrencyModal"]);
  }
  public function  UploadAttatchments($currency_id)
  {
    $currency = Currency::find($currency_id);

    if ($this->avatar) {
      $currency->clearMediaCollection('avatar');


      $currency
        ->addMedia($this->avatar->getRealPath())
        ->usingFileName($this->avatar->getClientOriginalName())
        ->toMediaCollection('avatar');
    }
  }
  public  function  editCurrency($id)
  {
    $this->confirmedDefaultChange = false;
    $currency = Currency::find($id);
    $this->currency_object = $currency;
    $this->currency = $currency->toArray();
    $this->editing = true;
    $codes = array_column($this->currencies, 'code');
    if (!in_array($this->currency['code'], $codes)) {
      $this->custom_code = $this->currency['code'];
      $this->currency['code'] = "__custom";
    }
    $this->currency['is_default'] = (bool) $this->currency['is_default'];
    $this->avatar = null;
    $this->dispatch("open_modal", ['action' => "show", "id" => "MoneyCurrencyModal"]);
  }
  public  function mount()
  {
    $this->currencies = config('currencies');
    $this->currency['code'] = $this->currencies[0]['code'];
  }
  public  function deleteCurrency($data)
  {
    try {
      $id = $data['currency_id'];
      $currency = Currency::find($id);
      $currency->delete();
      $this->dispatch("sweetalert:success", ['msg' => __('currency.currency_deleted_successfully'), 'title' => __('Success')]);
      $this->dispatch("RefreshYajraDatatable", ['table' => 'currencytable-table']);
      $this->dispatch("UnBlockUI");
    } catch (\Exception $e) {
      $this->dispatch("sweetalert:error", ['msg' => $e->getMessage(), 'title' => __('Error')]);
      $this->dispatch("UnBlockUI");
    }
  }

  public  function  ConfirmChangeDefaultCurrency()
  {
    $this->dispatch("sweetalert:confirm", ['msg' => __('alerts.areyousure'), 'emitName' => 'changeDefaultCurrency', 'action' => __('actions.change_default_currency'), 'title' => __('actions.change_default_currency'), 'data' => ['currency_id' => $this->currency['id']]]);
  }

  public function changeDefaultCurrency()
  {
    // Set exchange rate to 1 and factor to multiply for default currency
    $this->currency['exchange_rate'] = 1;
    $this->currency['rate_factor'] = 'multiply';
    $this->currency['is_default'] = true;

    // Mark that user has confirmed the default currency change
    $this->confirmedDefaultChange = true;

    // Now save the currency (this will bypass the confirmation check)
    $this->SaveCurrency();
  }
  public  function SaveCurrency()
  {

    try {
      $rules = [
        'currency.code' => 'required',
        'currency.name' => 'required',
        'currency.exchange_rate' => 'required|numeric',
      ];

      // Add unique validation only when creating new currency (not editing)
      if (!isset($this->currency['id'])) {
        $rules['currency.code'] .= '|unique:currencies,code';
      }
      $this->validate($rules);
      $nameTranslations = $this->currency['name'] ?? [];

      if ($this->custom_code && $this->currency['code'] == "__custom") {
        $this->currency['code'] = $this->custom_code;
      }

      // Check if user is trying to set currency as default (both new and edit)
      if (isset($this->currency['is_default']) && $this->currency['is_default'] && !$this->confirmedDefaultChange) {
        // Check if there's already a default currency
        $existingDefault = Currency::where('is_default', 1)->first();

        if ($existingDefault && (!isset($this->currency['id']) || $existingDefault->id != $this->currency['id'])) {
          // Ask for confirmation before changing default currency
          $this->dispatch("areyousure", [
            'msg' => __('alerts.confirm_change_default_currency'),
            'emitName' => 'changeDefaultCurrency',
            'action' => __('actions.change_default_currency'),
            'title' => __('actions.change_default_currency'),
            'data' => ['currency_id' => $this->currency['id'] ?? null]
          ]);
          return; // Stop here, wait for confirmation
        }
      }

      // Start database transaction to ensure atomicity
      DB::beginTransaction();

      try {
        // Handle default currency logic
        if (isset($this->currency['is_default']) && $this->currency['is_default']) {
          // If setting this currency as default, unset any other default currency
          Currency::where('is_default', 1)->update(['is_default' => 0]);
        }

        if (isset($this->currency['id'])) {
          $currency = Currency::find($this->currency['id']);
          $currency->update($this->currency);
        } else {
          $currency = Currency::create($this->currency);
        }

        $this->UploadAttatchments($currency->id);

        // If everything succeeded, commit the transaction
        DB::commit();

        $this->currency = ['code' => null, 'name' => null, 'is_default' => false];
        $this->dispatch("open_modal", ['action' => "hide", "id" => "MoneyCurrencyModal"]);
        $this->dispatch("sweetalert:success", ['msg' => __('alerts.saved_successfully'), 'title' => __('Success')]);
        $this->dispatch("RefreshYajraDatatable", ['table' => 'currencytable-table']);
      } catch (\Exception $e) {
        // If anything failed, rollback the transaction
        DB::rollBack();
        throw $e; // Re-throw to be caught by outer catch block
      }
    } catch (ValidationException $e) {
      $firstField = array_key_first($e->validator->errors()->messages());
      $firstErrorMessage = $e->validator->errors()->first($firstField);
      $this->dispatch('focus-error', ['field' => $firstField]);
      $this->dispatch("sweetalert:error", [
        'msg' => $firstErrorMessage,
        'title' => __("alerts.error"),
        'type' => "error"
      ]);
      throw $e; // rethrow so Livewire still shows errors
    } catch (\Exception $e) {
      $this->dispatch("sweetalert:error", ['msg' => $e->getMessage(), 'title' => 'Error']);
    }
  }
  public function render()
  {
    return view('livewire.currency.add');
  }
}
