<?php

namespace App\Livewire\Exchange;

use App\Services\ExchangeRates\ExchangeRateManager;
use Livewire\Component;

class LiveRates extends Component
{
  public array $rates = [];

  protected ExchangeRateManager $manager;


  public function mount()
  {

    // $manager_config = config('Orange.exchange.default');
    // $manager = new ExchangeRateManager($manager_config);
    // $this->manager = $manager;
    //  $this->rates = $this->manager->getAllRates();
    $this->refreshRates();
  }

  public function refreshRates()
  {
    $manager = new ExchangeRateManager(config('Orange.exchange.default'));
    $this->rates = $manager->getAllRates();
  }
  public function setExchange($from, $to, $rate, $direction, $apiKey = null)
  {
    $factor = "multiply";
    $factor = getCurrencyFactor($from, $to, 'transfer');
    $data = [
      'from' => $from,
      'to' => $to,
      'rate' => $rate,
      'apiKey' => $apiKey, // type here means API key like TRY_USD.alis
      'factor' => $factor,
    ];

    $this->dispatch('SetExchange', $data);
  }

  public function render()
  {
    return view('livewire.exchange.live-rates');
  }
}
