<?php

namespace App\Livewire\Exchange;

use App\Models\AgentSypRate;
use Livewire\Component;

class SypPrices extends Component
{
    public $groupedRates = [];
    public $currencies = [];

    public function mount()
    {
        $rates = AgentSypRate::with(['agent', 'currency'])
            ->where('enabled', 1)
            ->get();

        // Get unique currencies for the table header
        $this->currencies = $rates->pluck('currency.name', 'currency.code')->unique();

        // Group rates by agent
        $this->groupedRates = $rates
            ->groupBy('agent_id')
            ->map(function ($items) {
                $agentName = $items->first()->agent->name ?? 'غير معروف';
                $currencyData = [];

                foreach ($items as $rate) {
                    $currencyData[$rate->currency->code] = [
                        'name'  => $rate->currency->name,
                        'price' => number_format($rate->sell_price, 0),
                    ];
                }

                return [
                    'agent_name' => $agentName,
                    'currencies' => $currencyData
                ];
            });
    }

    public function render()
    {
        return view('livewire.exchange.syp-prices');
    }
}
