<?php

namespace App\Livewire\Filter;

use App\Models\Agent;
use App\Models\Currency;
use Livewire\Component;

class AdvancedSearch extends Component
{
  public $filters = [
    'sender_id' => null,
    'receiver_id' => null,
    'recipient_name' => null,
    'recipient_phone' => null,
    'sender_client_name' => null,
    'sender_client_phone' => null,
    'currency' => null,
    'amount' => null,
    'delivery_currency' => null,
    'delivery_amount' => null,
    'send_fee' => null,
    'receiver_fee' => null,
    'from_date' => null,
    'to_date' => null,
    'type' => "all",
    'status' => "all",
  ];
  public $amount_operator = '=';
  public $delivery_amount_operator = '=';
  public $send_fee_operator = '=';
  public $receiver_fee_operator = '=';

  public $currencies = [];
  public $senders = [];
  public $receivers = [];

  public function mount()
  {
    $this->currencies = Currency::get();
    $this->senders = Agent::get();
    $this->receivers = $this->senders;
  }

  public function search()
  {
    // Clean up empty filters
    $activeFilters = array_filter($this->filters, function ($value) {
      return $value !== null && $value !== '';
    });



    // Add the fee operators if fees are being filtered
    if (!empty($this->filters['send_fee'])) {
      $activeFilters['send_fee_operator'] = $this->send_fee_operator;
    }

    if (!empty($this->filters['receiver_fee'])) {
      $activeFilters['receiver_fee_operator'] = $this->receiver_fee_operator;
    }
    if (!empty($this->filters['amount'])) {
      $activeFilters['amount_operator'] = $this->amount_operator;
    }

    if (!empty($this->filters['delivery_amount'])) {
      $activeFilters['delivery_amount_operator'] = $this->delivery_amount_operator;
    }

    // Emit event with the active filters
    $this->dispatch('filtersApplied', ["filters" => $activeFilters, "table_id" => 'advancedsearch-table']);
  }

  public function resetFilters()
  {
    $this->reset('filters', 'send_fee_operator', 'receiver_fee_operator');
    $this->dispatch('filters-reset');
  }

  public function render()
  {
    return view('livewire.filter.advanced-search');
  }
}
