<?php

namespace App\Livewire\Ledger;

use App\Models\CustomLedgerAccount;
use Livewire\Component;

class AccountTreeNode extends Component
{
  public $account;
  public $children = [];
  public $expanded = false;

  public function toggle()
  {
    if ($this->expanded) {
      $this->expanded = false;
      $this->children = [];
    } else {
      $this->loadChildren();
      $this->expanded = true;
    }
  }

  public function loadChildren()
  {
    $this->children = CustomLedgerAccount::with('names')
      ->where('parentUuid', $this->account->ledgerUuid)
      ->get();
  }

  public function addChildAccount($parentUuid)
  {
    $this->dispatch('addChildAccount', $parentUuid);
  }

  public function editAccount($ledgerUuid)
  {
    $this->dispatch('editAccount', $ledgerUuid);
  }

  public function deleteAccount($ledgerUuid)
  {
    $this->dispatch('deleteAccount', $ledgerUuid);
  }

  public function render()
  {
    return view('livewire.ledger.account-tree-node');
  }
}
