<?php

namespace App\Livewire\Notifications;

use App\Models\NotificationTemplate;
use Illuminate\Notifications\Notification;
use Livewire\Component;

class TemplateForm extends Component
{
    public $template = ["code" => "", "type" => "email"];
    public $status = true;
    public $sumBalance = false;
    protected function getListeners()
    {
        return [
            'addTemplate' => 'addTemplate',
            'editTemplate' => 'editTemplate',
            'DeleteNotificationTemplate' => 'DeleteNotificationTemplate',
        ];
    }
    public $placeholders = [
        ['label' => ["tr" => 'Cari İsmi', "en" => "Customer Name"], 'tag' => '%account_name%', 'color' => 'bg-green-500'],
        ['label' => ["tr" => 'Bakiye', "en" => "Balance"], 'tag' => '%balance%', 'color' => 'bg-green-500'],
        ['label' => ["tr" => 'Tarih', "en" => "Date"], 'tag' => '%date%', 'color' => 'bg-yellow-400'],
        ['label' => ["tr" => 'Son Ödeme Günü', "en" => "Last Payment Day"], 'tag' => '%last_pay_day%', 'color' => 'bg-pink-400'],
        ['label' => ["tr" => 'Son Tahsilat Tarihi', "en" => 'Last Payment Date'], 'tag' => '%last_pay_date%', 'color' => 'bg-red-400'],
        ['label' => ['tr' => 'Döviz İsmi', "en" => 'Currency Name'], 'tag' => '%currency%', 'color' => 'bg-purple-500'],
        ['label' => ['tr' => 'Portföy İsmi', "en" => 'Portfolio Name'], 'tag' => '%pf_name%', 'color' => 'bg-green-500'],
        ['label' => ["tr" => 'Bağımsız Bölüm', "en" => 'Independent Section'], 'tag' => '%pr_building_number%', 'color' => 'bg-green-500'],
        ['label' => ["tr" => 'Sözleşme Başlangıç Tarihi', "en" => 'Contract Start Date'], 'tag' => '%contract_start_date%', 'color' => 'bg-pink-400'],
        ['label' => ['tr' => 'Ödeme Günü', "en" => 'Payment Day'], 'tag' => '%payment_day%', 'color' => 'bg-pink-400'],
        ['label' => ['tr' => 'Ödeme Linki', "en" => 'Payment Link'], 'tag' => '%payment_link%', 'color' => 'bg-blue-600'],
    ];
    public function editTemplate($id)
    {
        $template = NotificationTemplate::find($id);
        $this->template = $template->toArray();
        $this->dispatch("open_modal", [
            'id' => 'newNotificationTemplate',
            'action' => "show",
        ]);
    }
    public function addTemplate()
    {
        $this->template = ["code" => "", "type" => "email"];


        $this->dispatch("open_modal", [
            'id' => 'newNotificationTemplate',
            'action' => "show",
        ]);
    }
    public function DeleteNotificationTemplate($data)
    {
        $template = NotificationTemplate::find($data["id"]);
        $template->delete();
        $this->dispatch("sweetalert:success", [
            'msg' => "Template deleted successfully.",
            'title' => __('Success'),
            'iconClass' => 'toast-success',
            'icon' => 'success',
        ]);
    }

    public function insertTag($tag)
    {
        $this->template["code"] .= ' ' . $tag;
    }


    public function save()
    {
        if ($this->template["id"]) {
            NotificationTemplate::find($this->template["id"])->update($this->template);
            $this->dispatch("sweetalert:success", [
                'msg' => "Template updated successfully.",
                'title' => __('Success'),
                'iconClass' => 'toast-success',
                'icon' => 'success',
            ]);
            return;
        }
        NotificationTemplate::create($this->template);

        $this->dispatch("sweetalert:success", [
            'msg' => "Template saved successfully.",
            'title' => __('Success'),
            'iconClass' => 'toast-success',
            'icon' => 'success',
        ]);
    }

    public function render()
    {
        return view('livewire.notifications.template-form');
    }
}
