<?php

namespace App\Livewire\Settings\Tabs;

use Livewire\Component;
use Livewire\WithFileUploads;
use Rawilk\Settings\Facades\Settings;

class General extends Component
{
    use WithFileUploads;
    public array $general = [
        'company_name' => '',
        'id_number' => '',
        'passport_no' => '',
        'country' => '',
        'city' => '',
        'address' => '',
        'postal_code' => '',
        'phone' => '',
        'email' => '',
    ];

    public $logo,
        $logo_image;
    public function mount()
    {
        foreach ($this->general as $key => $default) {
            $this->general[$key] = Settings::get("general.$key", $default);
        }
        $this->logo = Settings::get('logo', null);
        if ($this->logo) {
            $this->logo_image = 'storage/Logo/' . $this->logo;
        } else {
            $this->logo_image = null;
        }
    }

    public function saveGeneral()
    {
        foreach ($this->general as $key => $value) {
            Settings::set("general.$key", $value);
        }
        $this->validate([
            'logo' => 'image|max:1024', // 1MB Max
        ]);

        if ($this->logo) {
            $this->logo->store('Logo', 'public');
        }
        Settings::set('logo', $this->logo->hashName());


        $this->dispatch("sweetalert:success", [
            'msg' => 'General settings updated successfully',
            'title' => 'Success',
            'icon' => 'success'
        ]);
    }
    public function render()
    {
        return view('livewire.settings.tabs.general');
    }
}
