<?php

namespace App\Livewire\Settings\Tabs;

use App\Models\NotificationTemplate;
use Illuminate\Notifications\Notification;
use Livewire\Component;
use Rawilk\Settings\Facades\Settings;


class Notifications extends Component
{
    public array $channels = ['sms', 'email', 'whatsapp'];
    public array $enabledChannels = [];
    public array $events = ['lease_expired', 'pament_reminde', 'late_payment', 'payment_received'];
    public array $notificationTemplates = []; // ['event']['channel'] => template_id

    public array $templates = []; // ['channel'] => [Template Objects]
    public array $eventLabels = [
        'pament_reminde' => 'Payment Reminde',
        'late_payment' => 'Late Payment',
        'payment_received' => 'Payment Received',
        'lease_expired' => 'Lease Expired',
    ];
    public array $icons = [
        'sms' => 'message-circle',
        'email' => 'mail',
        'whatsapp' => 'brand-whatsapp',
    ];
    public function mount()
    {

        // Example: load templates from DB
        $this->templates = [
            'sms' => NotificationTemplate::where('type', 'sms')->get(),
            'email' => NotificationTemplate::where('type', 'email')->get(),
            'whatsapp' => NotificationTemplate::where('type', 'whatsapp')->get(),
        ];

        // Load saved settings (optional)
        $this->enabledChannels = Settings::get('notifications.enabled_channels', ['sms', 'email', 'whatsapp']);

        // Load saved templates or default empty array
        $this->notificationTemplates = Settings::get('notifications.templates', []);
    }
    public function save()
    {
        Settings::set('notifications.enabled_channels', $this->enabledChannels);
        Settings::set('notifications.templates', $this->notificationTemplates);
        $this->dispatch("sweetalert:success", [
            'msg' => 'Notifications settings updated successfully',
            'title' => 'Success',
        ]);
    }
    public function render()
    {
        return view('livewire.settings.tabs.notifications');
    }
}
