<?php

namespace App\Livewire\Sms;

use App\Models\SmsSetting;
use App\Services\Sms\SmsSender;
use Illuminate\Support\Facades\Log;
use Livewire\Component;

class SmsConfig extends Component
{
    public $config = [];
    public $phone_number;
    public function SaveConfig()
    {

        $config = $this->config;
        unset($config['id'], $config['created_at'], $config['updated_at']);

        SmsSetting::updateOrInsert(
            ['id' => 1],
            $config
        );

        $this->dispatch('sweetalert:success', [
            'msg' => 'SMS configuration saved successfully',
            'title' => 'Success',
            'positionClass' => 'toast-top-right',
            'iconClass' => 'toast-success',
        ]);
    }
    public  function mount()
    {
        $config = SmsSetting::first();
        if ($config) {
            $this->config = SmsSetting::first()->toArray() ?? [];
        }
    }
    public function SendTestSMS()
    {
        try {
            $sender = new SmsSender();

            $status = $sender->send($this->phone_number, 'Test SMS from Mulk Takibi ', ['MyApp']);

            if (!$status) {
                $this->dispatch('toastr:error', [
                    'msg' => 'SMS sending failed',
                    'title' => 'Error',
                    'positionClass' => 'toast-top-right',
                    'iconClass' => 'toast-error',
                ]);
                return;
            }
            $this->dispatch('toastr:success', [
                'msg' => 'SMS sent successfully',
                'title' => 'Success',
                'positionClass' => 'toast-top-right',
                'iconClass' => 'toast-success',
            ]);
            return;
        } catch (\Exception $e) {
            Log::error($e);
        }
    }
    public  function getBalance()
    {
        $sender = new SmsSender();
        $balance = $sender->getBalance();
        $this->dispatch('toastr:success', [
            'msg' => "Balance: " . $balance,
            'title' => 'Success',
            'positionClass' => 'toast-top-right',
        ]);
    }
    public function render()
    {
        return view('livewire.sms.sms-config');
    }
}
