<?php

namespace App\Livewire;

use Livewire\Component;
use App\DataTables\TransactionDataTable;
use App\Models\CustomLedgerAccount;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\Log;

class TransactionTable extends Component
{
  public $selectedAccount = null;
  public $accountType = null;
  public $tableId = 'transaction-table';

  protected $listeners = ['accountChanged'];

  public function mount()
  {
    // Initialize with default account if needed
    if (auth()->guard('agent')->check()) {
      $defaultAccount = CustomLedgerAccount::where('agent_id', auth()->guard('agent')->id())->first();
      if ($defaultAccount) {
        $this->selectedAccount = $defaultAccount->code;
        $this->accountType = $defaultAccount->extra['type'] ?? null;
      }
    }
  }

  public function accountChanged($accountCode)
  {
    $this->selectedAccount = $accountCode;

    if ($accountCode) {
      $account = CustomLedgerAccount::where('code', $accountCode)->first();
      $this->accountType = $account->extra['type'] ?? null;
    } else {
      $this->accountType = null;
    }

    // Log the event data
    Log::info('Dispatching refreshTransactionTable event', [
      'account' => $this->selectedAccount,
      'accountType' => $this->accountType
    ]);

    // Emit event to refresh the DataTable using modern Livewire syntax
    $this->dispatch('refreshTransactionTable', [
      'account' => $this->selectedAccount,
      'accountType' => $this->accountType
    ]);
  }

  public function getAvailableAccounts()
  {
    if (auth()->guard('agent')->check()) {
      return CustomLedgerAccount::where('agent_id', auth()->guard('agent')->id())

        ->get();
    }

    return collect();
  }

  /**
   * Test method to manually refresh the table
   */
  public function refreshTable()
  {
    $this->dispatch('refreshTransactionTable', [
      'account' => $this->selectedAccount,
      'accountType' => $this->accountType
    ]);
  }

  public function render()
  {
    return view('livewire.transaction-table');
  }
}
