<?php

namespace App\Livewire\Transfers;

use App\Models\LedgerTransfer;
use Livewire\Component;

class ShowTransferReceipt extends Component
{
  public  $transfer;
  public  $direction = "send";
  public  $header_text;
  public function mount()
  {
    $this->header_text = __("Transfer Receipt");
  }
  protected function getListeners()
  {
    return [
      'ShowTransferReceipt' => 'ShowTransferReceipt',
      'ShowDeliveryReceipt' => 'ShowDeliveryReceipt',
    ];
  }
  public  function  ShowTransferReceipt($transfer_id, $model = "LedgerTransfer")
  {
    $this->header_text = __("Transfer Receipt");
    $this->direction = "send";
    $model = "\App\Models\\" . $model;
    $this->transfer = $model::where('id', $transfer_id)->first();



    $this->dispatch("open_modal", ['action' => "show", "id" => "TransferReceiptModal"]);
  }
  public function ShowDeliveryReceipt($transfer_id, $model = "LedgerTransfer")
  {
    $this->direction = "deliver";
    $this->header_text = __("Delivery Receipt");
    $model = "\App\Models\\" . $model;
    $this->transfer = $model::where('id', $transfer_id)->first();
    $this->dispatch("open_modal", ['action' => "show", "id" => "TransferReceiptModal"]);
  }
  public function closeModal()
  {
    // Allow the modal to close by calling JavaScript function
    $this->dispatch('allowModalClose');

    // Dispatch event to notify that delivery receipt modal is closed
    if ($this->direction === "deliver") {
      $this->dispatch("deliveryReceiptClosed");
    }
  }
  public function render()
  {
    return view('livewire.transfers.show-transfer-receipt');
  }
}
