<?php

namespace App\Livewire\User;

use App\Models\Agent;
use App\Models\Role;
use App\Models\User;
use App\Services\WalletService;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Livewire\Component;
use Illuminate\Support\Str;
use Laravel\Fortify\Features;

class Add extends Component
{

  public array $other_infos = [];
  public $user = ['password' => null, 'gender' => "m", "currency" => "TRY"];
  public  $roles, $role;
  public $init_amount = 0;
  public $step = 1;
  public $address = ["country" => "Turkey"];
  public  $agents = [];
  public array $otherInfoFields = [
    ['name' => 'name', 'text' => ['tr' => 'ADI', 'en' => 'NAME']], //'Name'],
    ['name' => 'value', 'text' => ['tr' => 'DEĞER', 'en' => 'VALUE']], //'Value'],
  ];
  protected  function  getListeners()
  {
    return [
      'editUser' => 'editUser',
      'deleteUser' => 'DeleteUser',
      'userDeleteAlaert' => 'userDeleteAlaert',
      'openAddUserModal' => 'openAddUserModal',
      'toggleChangeUserStatus' => 'toggleChangeUserStatus',
      'reset2fa' => 'reset2fa',

    ];
  }
  public function reset2fa($id)
  {
    $user = User::findOrFail($id);


    $user->forceFill([
      'two_factor_secret' => encrypt(app('pragmarx.google2fa')->generateSecretKey()),
      'two_factor_recovery_codes' => encrypt(json_encode(
        collect(range(1, 8))->map(fn() => Str::random(10))->all()
      )),
    ])->save();



    $this->dispatch("refreshYajraDatatable", [
      'table' => 'user-table',
    ]);
    $this->dispatch("sweetalert:success", ['msg' => __("alerts.saved_successfully"), 'title' => "Success", 'type' => "success"]);
  }
  public function toggleChangeUserStatus($value)
  {
    try {
      $user = User::find($value);
      $user->status = !$user->status;
      $user->save();
      $this->dispatch("refreshYajraDatatable", [
        'table' => 'user-table',
      ]);
      $this->dispatch("sweetalert:success", ['msg' => __("alerts.saved_successfully"), 'title' => "Success", 'type' => "success"]);
    } catch (\Exception $e) {
      Log::error($e->getMessage());
    }
  }
  public function openAddUserModal()
  {
    $this->user = ['password' => null, 'gender' => "m"];
    $this->dispatch('open_modal', [
      'action' => 'show',
      'id' => 'addUserModal',
    ]);
  }
  public function userDeleteAlaert($id)
  {
    $this->dispatch('areyousure', ['msg' => __("alerts.areyousure"), 'emitName' => 'deleteUser', 'action' => __("actions.delete"), 'title' => __("alerts.delete"), 'data' => ['user_id' => $id]]);
  }
  public function  DeleteUser($data)
  {
    $id = $data['user_id'];
    $user = User::find($id);
    $user->delete();
    $this->dispatch("sweetalert:success", ['msg' => __("alerts.deleted_successfully"), 'title' => "Success", 'type' => "success"]);
    $this->dispatch("refreshYajraDatatable", [
      'table' => 'user-table',
    ]);
    $this->dispatch("UnBlockUI");
  }
  public  function  editUser($user_id)
  {
    $user = User::find($user_id);
    $this->user = $user->toArray();
    $this->dispatch('open_modal', [
      'action' => 'show',
      'id' => 'addUserModal',
    ]);
  }

  public function NextStep()
  {
    $step = $this->step;
    $rule_1 = [
      'user.firstname' => 'required',
      'user.lastname' => 'required',
      'user.email' => 'required|email|unique:users,email,' . ($this->user['id'] ?? 'NULL'),
      'user.phone' => 'required',
      'user.gender' => 'required',
      'role' => 'required',
    ];
    $rule_2 = [
      'address.zipcode' => 'numeric|nullable',
      'address.country' => 'nullable',
      'address.city' => 'nullable',
      'address.state' => 'nullable',
      'address.lat' => 'nullable',
      'address.long' => 'nullable',
      'address.full_address' => 'nullable| max:60',
    ];
    $this->validate(${"rule_$step"});
    $this->step++;
  }
  public  function Updated($name, $value) {}
  public function PrevStep()
  {
    $this->step--;
  }
  public function mount()
  {
    $this->agents = Agent::isAgent()->get();
    $this->roles = Role::get();

    $this->role = optional($this->roles->first())->name ?? null;

    if (isset($this->user['id'])) {
      $user = User::find($this->user['id']);
      $this->user = $user->toArray();
      $this->role =  optional($user->roles)->first()->name ?? null;
      $this->address = $user->getPrimaryAddress() ? $user->getPrimaryAddress()->toArray() : [];
      $this->other_infos = $user->otherInfos ? $user->otherInfos->toArray() : [];
    }
  }

  public function AddUser()
  {


    $password = Str::random(8);
    $this->user['password'] = Hash::make("$password");

    $this->user['name'] = $this->user['firstname'] . ' ' . $this->user['lastname'];
    if (isset($this->user['id'])) {
      $user = User::find($this->user['id']);

      $user->update($this->user);

      $user->save();
    } else {

      $user = User::create($this->user);
      if (Features::enabled(Features::twoFactorAuthentication())) {
        $user->forceFill([
          'two_factor_secret' => encrypt(app('pragmarx.google2fa')->generateSecretKey()),
          'two_factor_recovery_codes' => encrypt(json_encode(
            collect(range(1, 8))->map(fn() => Str::random(10))->all()
          )),
        ])->save();
      }
    }
    $user->assignRole($this->role);
    if ($this->address) {
      $user->createOrUpdateAddress($this->address);
    }

    $this->dispatch("sweetalert:success", [
      'type' => 'success',
      'msg' => __("alerts.saved_successfully"),

    ]);
    $this->dispatch("refreshYajraDatatable", [
      'table' => 'user-table',
    ]);
  }

  public function render()
  {
    return view('livewire.user.add');
  }
}
