<?php

namespace App\Livewire\User;

use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\Attributes\Validate;

class View extends Component
{
    use WithFileUploads;
    public $user;
    public $tab = "dashboard";
    public  $property;
    #[Validate('image|max:1024')] // 1MB Max
    public $avatar;

    public function UpdatedAvatar()
    {
        $user = $this->user;
        $user->clearMediaCollection('avatar');
        $user
            ->addMedia($this->avatar->getRealPath())
            ->usingFileName($this->avatar->getClientOriginalName())
            ->toMediaCollection('avatar');
    }
    public  function  mount()
    {
        $this->property = $this->user->property;
    }
    public  function changeTab($tab)
    {
        $this->tab = $tab;


        if ($tab == "documents") {
            $modelname = "User";
            $modelid = $this->user->id;
            $this->dispatch('initElfinder', [
                'modelname' => $modelname,
                'modelid' => $modelid,
            ]);
        }
    }
    public function  ChangeStatus()
    {
        $this->user->is_active = !$this->user->is_active;
        $this->user->save();
    }
    public function editUser()
    {

        $this->dispatch('open_modal', [
            'id' => 'addUserModal',
            'action' => 'show'
        ]);
    }
    public function render()
    {
        return view('livewire.user.view');
    }
}
