<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AgentTransferPackageDetail extends Model
{
    protected $fillable = [
        'agent_id',
        'package_id',
        'min_amount',
        'max_amount',
        'send_fee',
        'receive_fee',
        'another_fee',
        'send_fee_type',
        'receive_fee_type'
    ];

    public function agent()
    {
        return $this->belongsTo(Agent::class);
    }

    public function package()
    {
        return $this->belongsTo(TransferPackage::class);
    }
}
