<?php

namespace App\Models;

use App\Traits\HasAddress;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Testing\Fluent\Concerns\Has;
use Spatie\Translatable\HasTranslations;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use App\Interfaces\Avatar;
use App\Traits\HasAvatar;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use Spatie\MediaLibrary\Conversions\Manipulations;
use Illuminate\Support\Arr;
use App\Traits\CustomAuditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Laravel\Scout\Searchable;
use OwenIt\Auditing\Contracts\Auditable;

class Client extends Model  implements HasMedia, Avatar, Auditable
{
    use HasFactory;
    use HasTranslations;
    use HasAddress;
    use InteractsWithMedia;
    use HasAvatar;
    use \OwenIt\Auditing\Auditable, CustomAuditable;
    public $translatable = ['name'];
    use SoftDeletes;

    protected $fillable = [
        'name',
        'phone',
        'gender',
        'mobile',
        'nationality',
        'place_of_birth',
        'date_of_birth',
        'mother_name',
        'father_name',
        'identity_type',
        'identity_number',
        'job',
        'notes',
        'user_id',
        'place_of_birth',

        'type'
    ];
    protected $casts = [
        'name' => 'array'
    ];
    public function getDefaultAvatar()
    {
        $gender = $this->gender ?? "m";
        return '/assets/img/avatars/' . $gender . '.jpg';
    }

    public  function IdentityType()
    {
        return $this->belongsTo(IdentityType::class, 'identity_type');
    }

    public function registerMediaConversions(?Media $media = null): void
    {
        $this->addMediaConversion('thumb')

            ->background('ffffff')
            ->sharpen(10)
            ->quality(90)
            // ->withManipulations([
            //     'border-radius' => '100%', // not always supported, see below
            // ])
            ->nonQueued();
    }
}
