<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;
use OwenIt\Auditing\Models\Audit;

class CustomAudit extends  Audit
{
  public function agent()
  {
    return $this->belongsTo(Agent::class, 'agent_id');
  }
  public function user()
  {
    return $this->belongsTo(User::class, 'user_id');
  }
  public function getData($queryBuilder, array $filters = [], $type = "data", $datatype = "all")
  {

    Log::info($filters);
    foreach ($filters as $filter => $value) {

      if (isset($value) && $value != "") {

        $queryBuilder = $this->getquery($queryBuilder, $filter, $value);
      }
    }
    return $queryBuilder;
  }
  public function getquery($query, $key, $value)
  {
    Log::info($key);

    if ($key == 'created_at') {
      return $query->whereDate('created_at', $value);
    }

    // Default case for other filters
    return $query->where($key, $value);
  }


  public function scopeFilter($query, $filters)
  {
    $query = $this->getData($query, $filters);

    return $query;
  }
}
