<?php

namespace App\Models;

use App\Services\ExchangeRates\ExchangePriceResolver;
use Illuminate\Database\Eloquent\Model;
use App\Traits\CustomAuditable;
use OwenIt\Auditing\Contracts\Auditable;

class ExchangePrice extends Model implements Auditable
{
  use \OwenIt\Auditing\Auditable, CustomAuditable;
  protected  $fillable = [
    'from_currency',
    'to_currency',
    'price_source',
    'static_price',
    'api_key',
    'difference',
    'operation',
    'type',
    'active_for_customers',
  ];
  protected $appends = [
    'rate'
  ];
  public function getRateAttribute()
  {
    try {
      $service = new ExchangePriceResolver();
      return $service->resolve($this);
    } catch (\Exception $e) {
      return 1;
      return;
    }
  }
  public  function fromCurrency()
  {
    return $this->belongsTo(Currency::class, 'from_currency', 'code');
  }
  public  function toCurrency()
  {
    return $this->belongsTo(Currency::class, 'to_currency', 'code');
  }
}
