<?php

namespace App\Models;

use App\Casts\WalletCast;
use App\Enums\WalletSlug;
use Bavix\Wallet\Models\Wallet as BaseWallet;

class Wallet extends BaseWallet
{

    protected $fillable = [
        'holder_type',
        'holder_id',
        'uuid',
        'name',
        'slug',
        'description',
        'meta',
        'balance',
        'decimal_places',
        'contract_id',

    ];
    protected $casts = [
        'meta' => 'array', // Important to cast meta as array
        'balance' => "float"
    ];

    protected $appends = [
        'formated_balance',

    ];
    public function getCurrencyAttribute(): string
    {
        return $this->meta['currency'] ?? 'TRY'; // Default to TRY instead of Default
    }
    public function getFormatedBalanceAttribute($value)
    {
        return $this->balance . ' ' . $this->currency;
    }

    /**
     * Accessor to get the cari code from meta.
     */
    public function getCariCodeAttribute(): ?string
    {
        return $this->meta['cari_code'] ?? null;
    }

    /**
     * Mutator to set the cari code inside meta.
     */
    public function setCariCodeAttribute($value)
    {
        $meta = $this->meta;
        $meta['cari_code'] = $value;
        $this->meta = $meta;
    }

    /**
     * Scope to get main wallet (default slug).
     */
    public function scopeMain($query)
    {
        return $query->where('slug', 'default');
    }
    public function scopeRent($query)
    {
        return $query->where('name', 'Kira');
    }
    public function scopeKira($query)
    {
        return $query->where('name', 'Kira');
    }
    public function scopeDeposit($query)
    {
        return $query->where('name', 'Depozito');
    }
    public function getBalanceAttribute(): string
    {
        // Use raw value to avoid infinite recursion
        $rawBalance = $this->getRawOriginal('balance');

        if (($this->name == WalletSlug::RENT || $this->name == "Kira") && $this->holder_type == User::class) {
            $user = $this->holder;
            $outstanding = $user->OutstandingInvoicesAmount();
            return $rawBalance - $outstanding;
        }

        return $rawBalance;
    }

    public function customTest()
    {
        return 'Custom Wallet class is working';
    }
}
