<?php

namespace App\Observers;

use App\Services\Transfer\BookingService;
use Illuminate\Support\Facades\Auth;
use OwenIt\Auditing\Events\AuditCustom;
use Illuminate\Support\Facades\Event;

class BookingObserver
{

  public function  created($transfer)
  {

    $service = new BookingService();

    //  $service->createTransferLedgerEntries($transfer);
    $transfer->disableAuditing();
    // $description = generateTransferDescription($transfer);
    // $old_desc = $transfer->notes;
    // $transfer->notes = $description;
    // if ($transfer->status != 'reverse')
    //     $transfer->notes = $old_desc . " " . $description;
    // $transfer->save();


    // $transfer = $service->create($transfer);



    $transfer::enableAuditing();

    $transfer->auditEvent = 'Create_Booking';
    $transfer->isCustomEvent = true;
    $transfer->auditCustomOld = [];

    $transfer->auditCustomNew = [
      "sender" => $transfer->sender->name,
      "receiver" => $transfer->receiver->name,
      "amount" => $transfer->amount,
      "receiver_fee" => $transfer->receiver_fee,
      "sender_fee" => $transfer->sender_fee,
      "delivery_amount" => $transfer->delivery_amount,
      "currency" => $transfer->currency,
      "delivery_currency" => $transfer->delivery_currency,
      "status" => "Completed"
    ];

    // Step 6: Dispatch the custom audit event
    Event::dispatch(new AuditCustom($transfer));
    $transfer->disableAuditing();
  }
  public function creating($transfer)
  {
    $transfer->disableAuditing();
    $transfer->user_id = Auth::user()->id ?? 1;
  }
}
