<?php

namespace App\Observers;

use Abivia\Ledger\Messages\Currency;
use Abivia\Ledger\Http\Controllers\LedgerCurrencyController;
use Abivia\Ledger\Messages\Message;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Abivia\Ledger\Exceptions\Breaker;
use Abivia\Ledger\Http\Controllers\LedgerAccountController;
use Abivia\Ledger\Messages\Account;
use Abivia\Ledger\Messages\Create;
use App\Services\Ledger\AgentLedgerService;

class CurrencyObserver
{

    public function  created($currency)
    {


        $currencyMessage = new Currency();
        $currencyMessage->code = $currency->code; // Currency code
        $currencyMessage->decimals = 3; // Number of decimal places
        if ($currency->code != "USD") {
            $controller = new LedgerCurrencyController();
            $response = $controller->run($currencyMessage, Message::OP_ADD);
        }
        $service = new AgentLedgerService();
        $service->CreateCurrencyExchangeSellBuyLedger($currency);

        // dispatch(
        //     new \App\Jobs\CreateNewCurrencyLedgerJob($currency)
        // );
    }
}
