<?php

namespace App\Policies;

use App\Models\LedgerExchange;
use App\Models\User;
use Illuminate\Auth\Access\Response;
use Rawilk\Settings\Facades\Settings;

class LedgerExchangePolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, LedgerExchange $ledgerExchange): bool
    {
        return false;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): Response
    {
        $start_time = Settings::get("system.exchange_start_time", 0); // default to 0
        $end_time = Settings::get("system.exchange_end_time", 24);    // default to 24

        $withinAllowedHours = now()->hour >= $start_time && now()->hour <= $end_time;

        if (! $withinAllowedHours) {
            return Response::deny('تم  تجاوز الوقت المسموح  لاجراء الصرافة . يمكنك انشاء صرافة   بين  ' . $start_time . ' و ' . $end_time);
        }

        return Response::allow();
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, LedgerExchange $ledgerExchange): bool
    {
        return false;
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, LedgerExchange $ledgerExchange): bool
    {
        return false;
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, LedgerExchange $ledgerExchange): bool
    {
        return false;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, LedgerExchange $ledgerExchange): bool
    {
        return false;
    }
}
