<?php

namespace App\Providers;

use App\Actions\Fortify\CreateNewUser;
use App\Actions\Fortify\ResetUserPassword;
use App\Actions\Fortify\UpdateUserPassword;
use App\Actions\Fortify\UpdateUserProfileInformation;
use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Str;
use Laravel\Fortify\Contracts\LoginResponse;
use Laravel\Fortify\Fortify;

class FortifyServiceProvider extends ServiceProvider
{

    public function register(): void
    {

        $host = request()->getHost();

        if ($host === env('ADMIN_URL')) {
            config(['fortify.domain' => $host]);
            config(['fortify.guard' => 'web']);
            // Fortify::authenticateUsing(function (Request $request) {
            //     return Auth::guard('web')->attempt($request->only(Fortify::username(), 'password'))
            //         ? Auth::guard('web')->user()
            //         : null;
            // });
        } else {
            config(['fortify.domain' => $host]);
            config(['fortify.guard' => 'agent']);
            // Fortify::authenticateUsing(function (Request $request) {
            //     return Auth::guard('agent')->attempt($request->only(Fortify::username(), 'password'))
            //         ? Auth::guard('agent')->user()
            //         : null;
            // });
        }
    }

    public function boot(): void
    {
        // $this->app->singleton(LoginResponse::class, function () {
        //     return new class implements LoginResponse {
        //         public function toResponse($request)
        //         {
        //             $user = $request->user();
        //             if (! $user) {
        //                 return redirect()->route('login');
        //             }

        //             // Redirect to 2FA setup if not yet done
        //             if (! $user->two_factor_confirmed_at) {
        //                 return redirect()->route('two-factor.setup');
        //             }

        //             // Normal redirect after login
        //             return redirect()->intended(config('fortify.home'));
        //         }
        //     };
        // });
        $host = request()->getHost();

        // Admin-specific configurations
        if ($host === env('ADMIN_URL')) {
            $this->configureAdminFortify();
        }
        // Agent-specific configurations
        elseif ($host === env('AGENT_URL')) {
            $this->configureAgentFortify();
        }

        $this->configureSharedFortifySettings();
    }

    protected function configureAdminFortify(): void
    {
        config(['fortify.guard' => 'web']);
        config(['auth.guard' => 'web']);

        Fortify::loginView(fn() => view('auth.login'));
        Fortify::registerView(fn() => view('auth.register'));
        Fortify::requestPasswordResetLinkView(fn() => view('auth.forgot-password'));
        Fortify::resetPasswordView(fn($request) => view('auth.reset-password', ['request' => $request]));
        Fortify::verifyEmailView(fn() => view('auth.verify-email'));
        Fortify::twoFactorChallengeView(fn() => view('auth.two-factor-challenge'));

        // Fortify::authenticateUsing(function (Request $request) {
        //     return Auth::guard('web')->attempt($request->only(Fortify::username(), 'password'))
        //         ? Auth::guard('web')->user()
        //         : null;
        // });
    }
    protected function configureAgentFortify(): void
    {


        config(['auth.guard' => 'agent']);
        config(['fortify.guard' => 'agent']);
        config(['auth.defaults.guard' => 'agent']);
        config(['fortify.passwords' => 'agents']); // ✅ Use correct broker
        Fortify::loginView(fn() => view('AgentPanel.auth.login'));


        // Remove the authenticateUsing callback for agent
    }

    protected function configureSharedFortifySettings(): void
    {
        Fortify::createUsersUsing(CreateNewUser::class);
        Fortify::updateUserProfileInformationUsing(UpdateUserProfileInformation::class);
        Fortify::updateUserPasswordsUsing(UpdateUserPassword::class);
        Fortify::resetUserPasswordsUsing(ResetUserPassword::class);
        Fortify::resetPasswordView(fn($request) => view('AgentPanel.auth.reset-password', ['request' => $request]));
        Fortify::verifyEmailView(fn() => view('AgentPanel.auth.verify-email'));
        Fortify::twoFactorChallengeView(fn() => view('AgentPanel.auth.two-factor-challenge'));
        RateLimiter::for('login', function (Request $request) {
            $throttleKey = Str::transliterate(Str::lower($request->input(Fortify::username())) . '|' . $request->ip());
            return Limit::perMinute(5)->by($throttleKey);
        });

        RateLimiter::for('two-factor', function (Request $request) {
            return Limit::perMinute(5)->by($request->session()->get('login.id'));
        });
    }
}
