<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\Rule;
use Illuminate\Contracts\Validation\ValidationRule;

class LessthanOrEqual implements ValidationRule
{
    protected $max;

    public function __construct($max)
    {
        $this->max = $max;
    }

    /**
     * Run the validation rule.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     * @return void
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if ($value > $this->max) {
            $fail('insert less than or equal   ' . $this->max . '.');
        }
    }
}
