<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class MinWords implements ValidationRule
{
  protected $minWords;
  protected $maxWords;

  public function __construct($minWords, $maxWords = null)
  {
    $this->minWords = $minWords;
    $this->maxWords = $maxWords;
  }

  /**
   * Run the validation rule.
   */
  public function validate(string $attribute, mixed $value, Closure $fail): void
  {
    if (!is_string($value)) {
      $fail('The :attribute must be a string.');
      return;
    }

    $words = explode(' ', trim($value));
    $wordCount = count(array_filter($words, 'strlen')); // Count non-empty words

    if ($wordCount < $this->minWords) {
      $fail("The :attribute must contain at least {$this->minWords} words.");
      return;
    }

    if ($this->maxWords && $wordCount > $this->maxWords) {
      $fail("The :attribute must contain no more than {$this->maxWords} words.");
    }
  }
}
