<?php

namespace App\Services\Ledger;

use Abivia\Ledger\Messages\Reference;
use Abivia\Ledger\Messages\EntityRef;
use Abivia\Ledger\Http\Controllers\JournalReferenceController;

class ReferenceService
{
    public function createReference(string $code, array $extra = [], string $domain = 'DEFAULT')
    {
        $reference = new Reference();
        $reference->code = $code;
        $reference->domain = new EntityRef();
        $reference->domain->code = $domain;
        $reference->extra = json_encode($extra);

        $controller = new JournalReferenceController();
        return $controller->add($reference);
    }
}
