<?php

namespace App\Services\Sms;

use App\Models\SmsGateway;
use App\Services\Sms\Gateways\IletiMerkeziGateway;
use App\Services\Sms\Gateways\MutlucellGateway;
use App\Services\Sms\Gateways\NetgsmGateway;
use App\Services\Sms\Gateways\SmsGatewayInterface;

class SmsGatewayManager
{
    public function getActiveGateway(): SmsGatewayInterface
    {
        $gateway = SmsGateway::where('is_active', true)->where('is_default', true)->firstOrFail();

        $config = json_decode($gateway->config, true);

        return match ($gateway->slug) {
            'iletimerkezi' => new IletiMerkeziGateway($config),
            'mutlucell'    => new MutlucellGateway($config),
            'netgsm'       => new NetgsmGateway($config),
            default        => throw new \Exception("Unsupported SMS gateway: {$gateway->slug}"),
        };
    }


    public function send(string $to, string $message): bool
    {
        return $this->getActiveGateway()->send($to, $message);
    }
}
