<?php

namespace App\Services;

use App\Enums\WalletSlug;
use App\Helpers\CariCodeHelper;
use App\Models\User;
use Bavix\Wallet\Models\Wallet;

class WalletService
{
    public static function createDefaultWallets($owner, $contractId = null)
    {
        $prefix = 'MLK'; // Static prefix
        $tenantId = $owner->id;


        $wallets = [
            ['name' => 'main',         'slug' => 'main',     'segments' => []],
            // just contract level
            ['name' => 'Kira',        'slug' => WalletSlug::RENT,     'segments' => [2, 1, 1]],
            ['name' => 'Depozito',    'slug' =>  WalletSlug::Deposit,  'segments' => [2, 1, 2]],
            ['name' => 'Peşinat',     'slug' => WalletSlug::Advance,  'segments' => [2, 1, 3]],
            ['name' => 'Yasal Takip', 'slug' => WalletSlug::Legal,    'segments' => [2, 1, 4]],
        ];
        foreach ($wallets as $wallet) {
            if (!$owner->getWallet($wallet['name'])) {
                $cariCode = generateCariCode($prefix, $tenantId, $contractId, $wallet['segments']);

                $owner->createWallet([
                    'name' => $wallet['name'],
                    'slug' => $cariCode,
                    'meta' => [
                        'cari_code' => $cariCode,
                    ],
                    'contract_id' => $contractId,
                    'tenant_id' => $tenantId,
                ]);
            }
        }
    }
}
