<?php

namespace App\Traits;

trait GeneratesLedgerCodes
{
    /**
     * Generate a structured ledger account code.
     *
     * @param string $typePrefix e.g. '1' for asset, '2' for liability
     * @param string $countryCode ISO Alpha-2 (e.g. 'TR', 'SY')
     * @param string $subType e.g. 'CASH', 'LIAB'
     * @return string
     */
    public function generateLedgerCode(string $typePrefix, string $countryCode, string $subType): string
    {
        $id = $this->id ?? '0000'; // fallback for unsaved model
        return sprintf(
            '%s-%s-%04d-%s',
            $typePrefix,
            strtoupper($countryCode),
            $id,
            strtoupper($subType)
        );
    }
}
