<?php

namespace App\Traits;

use App\Models\Address;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphOne;

trait HasAddress
{
    /**
     * Get the address associated with the Addressable
     *
     * @return MorphOne
     */
    public function address(): MorphOne
    {
        return $this->morphOne(Address::class, 'addressable');
    }

    /**
     * Get the primary address of the Addressable
     *
     * @return Address|null
     */
    public function getPrimaryAddress(): ?Address
    {
        return $this->address()->first();
    }

    /**
     * Create a new address for the Addressable
     *
     * @param array $attributes
     * @return Address
     */
    public function createAddress(array $attributes): Address
    {
        return $this->address()->create($attributes);
    }

    /**
     * Update the address of the Addressable
     *
     * @param Address $address
     * @param array $attributes
     * @return bool
     */
    public function updateAddress(Address $address, array $attributes): bool
    {
        return $address->update($attributes);
    }
    public  function createOrUpdateAddress(array $attributes): Address
    {
        $address = $this->getPrimaryAddress();

        if ($address) {
            $this->updateAddress($address, $attributes);
        } else {
            $address = $this->createAddress($attributes);
        }

        return $address;
    }
    public function getFullAddress()
    {
        $country = $this->address()->first()->country ?? '';
        $city = $this->address()->first()->city ?? '';
        $state = $this->address()->first()->state ?? '';
        $region = $this->address()->first()->region ?? '';
        $neighborhood = $this->address()->first()->neighborhood ?? '';
        $address = $this->address()->first()->full_address ?? '';
        return  $country . '-' . $city . '-' . $state . '-' . $region . '-' . $neighborhood . '-' . $address;
    }
}
